//
//  $Id: NSString_FJNStringEncoding.h 84 2008-03-18 13:25:05Z fujidana $
//
//  Copyright (c) 2006-2008 FUJIDANA. All rights reserved.
//

#import <Foundation/Foundation.h>

/*!
@category NSString (FJNStringEncoding)
@abstract A FJNStringEncoding category enables <code>NSString</code> object to detect string encoding of the file.
@discussion A FJNStringEncoding category enables <code>NSString</code> object to detect string encoding of the file. Methods defined in this category internally uses Cocoa API newly defined in Mac OS X 10.4.
@availability Mac OS X 10.4 and later.
*/

@interface NSString (FJNStringEncoding)

/*!
@method stringWithContentsOfFile:usedJapaneseEncoding:error:
@abstract Returns a string created by reading data from the file at a given path and returns by reference the encoding used to interpret the file.
@discussion Cocoa API is used to guess a string encoding of a file. Supported encodings are as following: Unicode, UTF-8, Shift-JIS (Windows), ISO-2022-JP, EUC-JP, ASCII.
@param path A path to a file.
@param enc Upon return, if the file is read successfully, contains the encoding used to interpret the file at <var>path</var>.
@param outError If an error occurs, upon return contains an <code>NSError</code> object that describes the problem. If you are not interested in possible errors, pass in <code>NULL</code>.
@result A string created by reading data from the file named by <var>path</var>. If the file can’t be opened or there is an encoding error, returns <code>nil</code>.
@availability Mac OS X 10.4 and later.
*/
+ (id)stringWithContentsOfFile:(NSString *)path usedJapaneseEncoding:(NSStringEncoding *)enc error:(NSError **)outError;

/*!
@method stringWithContentsOfURL:usedJapaneseEncoding:error:
@abstract Returns a string created by reading data from a given URL and returns by reference the encoding used to interpret the data.
@discussion Cocoa API is used to guess a string encoding of the data. Supported encodings are as following: Unicode, UTF-8, Shift-JIS (Windows), ISO-2022-JP, EUC-JP, ASCII.
@param url The URL from which to read data.
@param enc Upon return, if <var>url</var> is read successfully, contains the encoding used to interpret the data.
@param outError If an error occurs, upon return contains an <code>NSError</code> object that describes the problem. If you are not interested in possible errors, pass in <code>NULL</code>.
@result A string created by reading data from <var>url</var>. If the URL can’t be opened or there is an encoding error, returns <code>nil</code>.
@availability Mac OS X 10.4 and later.
*/
+ (id)stringWithContentsOfURL:(NSURL *)url usedJapaneseEncoding:(NSStringEncoding *)enc error:(NSError **)outError;

/*!
@method initWithContentsOfFile:usedJapaneseEncoding:error:
@abstract Returns an <code>NSString</code> object initialized by reading data from the file at a given path using a given encoding.
@discussion Cocoa API is used to guess a string encoding of a file at a given path. Supported encodings are as following: Unicode, UTF-8, Shift-JIS (Windows), ISO-2022-JP, EUC-JP, ASCII.
@param path A path to a file.
@param enc Upon return, if the file is read successfully, contains the encoding used to interpret the file at <var>path</var>.
@param outError If an error occurs, upon return contains an <code>NSError</code> object that describes the problem. If you are not interested in possible errors, pass in <code>NULL</code>.
@result An <code>NSString</code> object initialized by reading data from the file named by <var>path</var> using the encoding, enc. The returned object may be different than the original receiver. If the file can’t be opened or there is an encoding error, returns <code>nil</code>.
@availability Mac OS X 10.4 and later.
*/
- (id)initWithContentsOfFile:(NSString *)path usedJapaneseEncoding:(NSStringEncoding *)enc error:(NSError **)outError;


/*!
@method initWithContentsOfURL:usedJapaneseEncoding:error:
@abstract Returns an <code>NSString</code> object initialized by reading data from a given URL interpreted using a given encoding.
@discussion Cocoa API is used to guess a string encoding of the data. Supported encodings are as following: Unicode, UTF-8, Shift-JIS (Windows), ISO-2022-JP, EUC-JP, ASCII.
@param url The URL from which to read data.
@param enc Upon return, if <var>url</var> is read successfully, contains the encoding used to interpret the data.
@param outError If an error occurs, upon return contains an <code>NSError</code> object that describes the problem. If you are not interested in possible errors, pass in <code>NULL</code>.
@result An <code>NSString</code> object initialized by reading data from <var>url</var>. If <var>url</var> can’t be opened or the encoding cannot be determined, returns <code>nil</code>. The returned initialized object might be different than the original receiver.
@availability Mac OS X 10.4 and later.
*/
- (id)initWithContentsOfURL:(NSURL *)url usedJapaneseEncoding:(NSStringEncoding *)enc error:(NSError **)outError;

- (id)initWithData:(NSData *)data usedJapaneseEncoding:(NSStringEncoding *)enc error:(NSError **)outError;

@end
